package gov.va.med.domain.service.messaging;

import gov.va.med.domain.service.messaging.Request;
import gov.va.med.domain.service.messaging.Response;


/**
 * @author Slava Uchitel
 * @version $Id: IMessageOriginator.java,v 1.12 2005/08/03 20:18:08 joel.goldberg Exp $
 * @since MHV 2.0 <br>03/27/2005
 */
public interface IMessageOriginator {
    /**
     *   Queues an extract request for each site and category at which the patient has 
     *   health records.  Each reauest is for all personal health records of for 
     *   a caterory and site since the last corresponding successful extract.  
     *   Will apply business rules and query the database to:  
     * <UL>
     * <LI>Ensure requests are sent to all sites where patient has record
     * <LI>Request extracts for all supported subject areas
     * <LI>Request extracts for a date range subsequent to the last successful extract
     *       for that site/category/patient, or a full extract if it is the first request.
     * <LI>Sequence the requests in priority order (priority on the PHR_FUNCTIONS table).
     *       If  the categoryType provided is not null,  this category is requested first.
     * </UL>
     * @param patient
     *            populated with UserIdSeq and ICN
     * @param categoryType
     *            the current category code corresponding to the portlet from
     *            which the user made the request, or null if not from within a
     *            category
     */
    //public void requestAllExtracts(Patient patient, String categoryType);
   
    /**
     * Make a synchronous call to a VistA site to for this RxRefillRequest request.
     * 
     * @param request containing an RxRefillPayload containing the patient on whose behalf the request
     *  is being made, and the institution to which the request will be sent.
     *  
     * @return Response containing RxRefillPayload or StatusPayload, or ErrorResponse ;
     */
    public Response sendRxRefillRequest(Request request);
    
    /**
     * Queues an MPI message (ADT-A24) to link a Patient with MHV, thus
     * subscribing MHV to MPI�s Patient Change Notifications broadcasts for this
     * patient. Writes the MessagingRequest to the database to track the ACK
     * response.
     * 
     * @param patient
     *            containing the icn and user id
     */
    //public void linkPatient(Patient patient);

    /**
     * Queues an MPI message (ADT-A37) to unlink a Patient from MHV, thus
     * unsubscribing the MHV from future Patient Change Notifications for this
     * patient. Writes the MessagingRequest to the database to track the ACK
     * response.
     * 
     * @param patient
     *            containing the icn and user id
     */
    //public void unlinkPatient(Patient patient);

    /**
     * Make Synchronous call to MPI lookup for the ICN (message VQQ_Q02)
     * retrieve the Patient and their treatment locations for patients mathcing
     * the user's last name, first name, social security number and date of
     * birth.
     * 
     * @param user
     *            containing the last name, first name, social security number
     *            and date of birth to match on in MPI
      * @return Response containing DtoListPayload or StatusPayload, or ErrorResponse if an exception occcred.
     * @throws MessagingException
     */
    //public Response lookupPatient(UserProfile user) throws MessagingException;

    /**
     * Send an acknowledgement to the sending application that a message was
     * received.
     * 
     * @param metaData
     *            message header info needed to send the ack
     */
    //public void sendApplicationAck(HL7MessageMetadata metaData);
    
    /** 
     * Reusable method to send any DestinedRequest as
     * 
     * @param request as needed for your purposes.  
     * @return Response containing RxRefillPayload or StatusPayload, or ErrorResponse 
     */
    public Response sendSynchronousMessage(DestinedRequest request);
    
    /**
     * Used to prequalfy a request by checking to ensure that the configuration and
     * is in place to send the function to endpoint.     
     *
     * NOTE:  This does not ensure no problems will occur,  
     * but guarantees that the Function has a legitmate association 
	 * with a Destination that supports it.   
	 * <P>
	 * Rationale: for providing this method  The request should not be issued if the 
	 * Destination is not valid for this Function becuase it will
	 * cause predictable and avoidable problems.  
	 * <UL>
	 * <LI>The patient may have records in a destination that
	 * has not been activated yet (highly likely during Alpha and Beta)<BR>
	 * <LI>The destination may exist but not be configured for this function
	 * (possible if the desitnation is set up for RX Refill but not for PHR)
	 * </UL> 
     * @param functionName as defined in the Functions table
     * @param institutionId with the Standard Institution id of the desination
     * @return true if it looks valid, false if not
     */
    //public boolean isFunctionValidForDestination(String functionName, long institutionId);
}